/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class RadarItem
extends Item {
    public RadarItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            if (playerIn.func_225608_bj_()) {
                DogLocationStorage locationManager = DogLocationStorage.get(worldIn);
                for (UUID uuid : locationManager.getAllUUID()) {
                    playerIn.func_145747_a((ITextComponent)new StringTextComponent(locationManager.getData(uuid).toString()), Util.field_240973_b_);
                }
                return new ActionResult(ActionResultType.FAIL, (Object)playerIn.func_184586_b(handIn));
            }
            RegistryKey dimCurr = playerIn.field_70170_p.func_234923_W_();
            playerIn.func_145747_a((ITextComponent)new StringTextComponent(""), Util.field_240973_b_);
            DogLocationStorage locationManager = DogLocationStorage.get(worldIn);
            List ownDogs = locationManager.getDogs((LivingEntity)playerIn, (RegistryKey<World>)dimCurr).collect(Collectors.toList());
            if (ownDogs.isEmpty()) {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("dogradar.errornull", new Object[]{dimCurr}), Util.field_240973_b_);
            } else {
                boolean flag = false;
                for (DogLocationData loc : ownDogs) {
                    if (!loc.shouldDisplay(worldIn, playerIn, handIn)) continue;
                    flag = true;
                    String translateStr = RadarItem.getDirectionTranslationKey(loc, (Entity)playerIn);
                    int distance = MathHelper.func_76143_f((double)(loc.getPos() != null ? loc.getPos().func_72438_d(playerIn.func_213303_ch()) : -1.0));
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent(translateStr, new Object[]{loc.getName(worldIn), distance}), Util.field_240973_b_);
                }
                if (!flag) {
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("dogradar.errornoradio"), Util.field_240973_b_);
                }
            }
            ArrayList<RegistryKey> otherDogs = new ArrayList<RegistryKey>();
            ArrayList noDogs = new ArrayList();
            for (RegistryKey worldkey : worldIn.func_73046_m().func_240770_D_()) {
                if (worldkey.equals(worldIn.func_234923_W_())) continue;
                ownDogs = locationManager.getDogs((LivingEntity)playerIn, (RegistryKey<World>)worldkey).collect(Collectors.toList());
                (ownDogs.size() > 0 ? otherDogs : noDogs).add(worldkey);
            }
            if (otherDogs.size() > 0) {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("dogradar.notindim", new Object[]{otherDogs.stream().map(RegistryKey::func_240901_a_).map(Objects::toString).collect(Collectors.joining(", "))}), Util.field_240973_b_);
            }
            if (noDogs.size() > 0 && stack.func_77973_b() == DoggyItems.CREATIVE_RADAR.get()) {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("dogradar.errornull", new Object[]{noDogs.stream().map(RegistryKey::func_240901_a_).map(Objects::toString).collect(Collectors.joining(", "))}), Util.field_240973_b_);
            }
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    public static String getDirectionTranslationKey(DogLocationData loc, Entity entity) {
        if (loc.getPos() == null) {
            return "dogradar.unknown";
        }
        Vector3d diff = loc.getPos().func_178787_e(entity.func_213303_ch().func_216371_e());
        double angle = MathHelper.func_181159_b((double)diff.func_82615_a(), (double)diff.func_82616_c());
        if (angle < -2.748893571891069) {
            return "dogradar.north";
        }
        if (angle < -1.9634954084936207) {
            return "dogradar.north.west";
        }
        if (angle < -1.1780972450961724) {
            return "dogradar.west";
        }
        if (angle < -0.39269908169872414) {
            return "dogradar.south.west";
        }
        if (angle < 0.39269908169872414) {
            return "dogradar.south";
        }
        if (angle < 1.178097245096172) {
            return "dogradar.south.east";
        }
        if (angle < 1.9634954084936211) {
            return "dogradar.east";
        }
        if (angle < 2.7488935718910685) {
            return "dogradar.north.east";
        }
        return "dogradar.north";
    }
}

